/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.tasks;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.servlet.jspemul.JSPEmulator;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.HMCSessionListener;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.servlet.util.WCLUtil;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ps.wcl.core.WclFacade;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ContentManager {
    private static final String TRACE_MASKT = "XTIFCTMT";
    private static final String CONTEXT_MANAGER_ATTRIBUTE_IN_SESSION = "tasks.contentmanager";
    HMCSession hmcSession;
    Listener listener;
    ServletContext servletContext;
    HttpSession httpSession;
    WclFacade wclFacade;

    public ContentManager(HMCSession hmcSession) {
        if (hmcSession.getSessionAttribute(CONTEXT_MANAGER_ATTRIBUTE_IN_SESSION) != null) {
            throw new IllegalStateException("A context manager is already attached to the HMCSession");
        }
        this.hmcSession = hmcSession;
        this.listener = new Listener();
        hmcSession.setSessionAttribute(CONTEXT_MANAGER_ATTRIBUTE_IN_SESSION, this);
        hmcSession.addHMCSessionListener(this.listener);
        if (!hmcSession.isDisconnected()) {
            this.processHMCSessionConnected();
        }
    }

    void prepareForRendering() throws HException {
        if (this.wclFacade == null) {
            this.createWclFacade();
        }
    }

    private void createWclFacade() throws HException {
        this.wclFacade = WCLUtil.getWCLUtil().createFacade(ServletRuntime.getRuntime().getHMCContextPath() + "/wcl/");
        this.hmcSession.getHMCCustomScope().setAttribute("taskInterface.facade", this.wclFacade);
    }

    public static synchronized ContentManager getContentManager(HMCSession hmcSession) {
        ContentManager contentManager = (ContentManager)hmcSession.getSessionAttribute(CONTEXT_MANAGER_ATTRIBUTE_IN_SESSION);
        if (contentManager == null) {
            contentManager = new ContentManager(hmcSession);
        }
        return contentManager;
    }

    public static ContentManager getContentManager(HttpSession httpSession) {
        HMCSession hmcSession = HMCSession.getHMCSession(httpSession);
        return ContentManager.getContentManager(hmcSession);
    }

    public WclFacade getWclFacade() {
        return this.wclFacade;
    }

    public void registerNameInContext(String name, Object object) {
        this.hmcSession.setContextAttribute(name, object);
    }

    public void deregisterNameInContext(String name) {
        this.hmcSession.removeContextAttribute(name);
    }

    public Object getNameFromContext(String name) {
        return this.hmcSession.getContextAttribute(name);
    }

    void renderContent(PanelModel panelModel, Servlet servlet, ServletContext servletContext, HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        JSPEmulator jspEmulator = null;
        try {
            jspEmulator = JSPEmulator.getEmulatorInstance(servletContext);
            jspEmulator.processMarkup(servlet, servletContext, panelModel, req, resp);
        }
        catch (Throwable e) {
            if (e instanceof ThreadDeath) {
                throw (ThreadDeath)e;
            }
            Trace.trace(TRACE_MASKT, "Received Exception rendering a PanelModel");
            Trace.trace(TRACE_MASKT, e);
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            throw new ServletException("Exception rendering a PanelModel", e);
        }
        finally {
            if (jspEmulator != null) {
                JSPEmulator.returnEmulatorInstance(jspEmulator, servletContext);
            }
        }
    }

    private synchronized void processHMCSessionDisconnected() {
        this.httpSession = null;
        this.servletContext = null;
    }

    private synchronized void processHMCSessionConnected() {
        this.httpSession = this.hmcSession.getHttpSession();
        this.servletContext = this.httpSession.getServletContext();
    }

    private synchronized void processHMCSessionDestroyed() {
        Trace.trace(TRACE_MASKT, "Destroying facade for HMC session.");
        if (this.wclFacade != null) {
            this.wclFacade.destroy();
        }
    }

    private class Listener
    implements HMCSessionListener {
        private Listener() {
        }

        public void sessionDisconnected(HMCSession session) {
            ContentManager.this.processHMCSessionDisconnected();
        }

        public void sessionConnected(HMCSession session) {
            ContentManager.this.processHMCSessionConnected();
        }

        public void sessionDestroyed(HMCSession session) {
            ContentManager.this.processHMCSessionDestroyed();
        }

        public void clientConnectivityLost(HMCSession session) {
        }

        public void clientConnectivityGained(HMCSession session) {
        }

        public void taskStarted(HMCSession session, PanelModelTaskPortal portal) {
        }

        public void taskEnded(HMCSession session, PanelModelTaskPortal portal) {
        }

        public void taskRealized(HMCSession session, PanelModelTaskPortal portal) {
        }
    }
}

